function [qv, correctedData]=integratenobaseline(data,intLimits,acq_period)

%integratenobaseline integrates the raw gating current between two user defined
%points, and returns the QV data. It is called by gatingwrapper

%This code ensures the user has entered two limits for the integration and the
%baseline
if length(intLimits)~=2
    error('Limit inputs must contain two values.');
end

%Initialize arrays for correctedData, the baseline, the integral of the
%data, and the QV values
correctedData=zeros(intLimits(2)-intLimits(1)+1,size(data,2));
integral=zeros(intLimits(2)-intLimits(1)+1,size(data,2));
qv=zeros(size(data,2),1);

for n=1:size(data,2)
    %Unnecessary line, except that it keeps downstream variable assignments
    %simpler
    correctedData(:,n)=data(intLimits(1):intLimits(2),n);
    %Integrate the data, accounting for the acquisition rate
    %and converting uA to A
    integral(:,n)=cumsum(correctedData(:,n))*1e-12*acq_period;
    %The line below could be used for future automatic normalized values of
    %the QV, it should provide the greatest value of Q that is found.
    [cow,i]=max(abs(integral(:,n)));
    %Set qv equal to the integral of the gating current, or Q
    qv(n)=integral(i,n);
end

%Assign x values for plots
x=(intLimits(1):intLimits(2))';
%Plot the raw data (assigned to variable correctedData)
figure;
plot(x,correctedData);
%Plot the integral of the gating current
figure;
plot(x,integral);
%Plot the qv
figure;
plot(qv,'o');
%output=[qv, correctedData];